<?php

/*--------------------------------------------------------------
# Copyright (C) joomla-monster.com
# License: http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
# Website: http://www.joomla-monster.com
# Support: info@joomla-monster.com
---------------------------------------------------------------*/

/**
 * @package     Joomla.Platform
 * @subpackage  Form
 *
 * @copyright   Copyright (C) 2005 - 2012 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */

defined('JPATH_PLATFORM') or die;

/**
 * Form Field class for the Joomla Platform.
 * Provides spacer markup to be used in form layouts.
 *
 * @package     Joomla.Platform
 * @subpackage  Form
 * @since       11.1
 */
class JFormFieldJmspacer extends JFormField
{
    /**
     * The form field type.
     *
     * @var    string
     * @since  11.1
     */
    protected $type = 'Jmspacer';

    /**
     * Method to get the field input markup for a spacer.
     * The spacer does not have accept input.
     *
     * @return  string  The field input markup.
     *
     * @since   11.1
     */
    protected function getInput()
    {
        return ' ';
    }

    /**
     * Method to get the field label markup for a spacer.
     * Use the label text or name from the XML element as the spacer or
     * Use a hr="true" to automatically generate plain hr markup
     *
     * @return  string  The field label markup.
     *
     * @since   11.1
     */
    protected function getLabel()
    {
        $formControl = $this->formControl;
        if ($this->group) {
            $formControl .= '_'.$this->group;
        }
        
        $fields = explode(',',$this->element['fields']);
        foreach($fields as $key=>$field) {
            $fields[$key] = trim($field);
        }
        
        if (count($fields) > 0) {
            $document = JFactory::getDocument();
            //$document->addScript(JURI::base().'../templates/'.$this->scriptPath.'/jmspacer.js');
            $document->addScriptDeclaration('
                window.addEvent("domready",function(){
                    var JMSpacer_'.$this->id.' = new JMSpacer("'.$this->id.'-lbl", "'.$formControl.'", '.json_encode($fields).');
                });
            ');
        }
        
        $html = array();
        $class = $this->element['class'] ? (string) $this->element['class'] : '';
        $class .= ' jmspacer';

        $html[] = '<span class="spacer">';
        $html[] = '<span class="before"></span>';
        $html[] = '<span class="' . $class . '">';
        
        $label = '';

        // Get the label text from the XML element, defaulting to the element name.
        $text = $this->element['label'] ? (string) $this->element['label'] : (string) $this->element['name'];
        $text = $this->translateLabel ? JText::_($text) : $text;

        // Build the class for the label.
        $class = !empty($this->description) ? 'hasTip' : '';

        // Add the opening label tag and main attributes attributes.
        $label .= '<label id="' . $this->id . '-lbl" class="' . $class . '"';

        // If a description is specified, use it to build a tooltip.
        if (!empty($this->description))
        {
            $label .= ' title="'
                . htmlspecialchars(
                trim($text, ':') . '::' . ($this->translateDescription ? JText::_($this->description) : $this->description),
                ENT_COMPAT, 'UTF-8'
            ) . '"';
        }

        // Add the label text and closing tag.
        $label .= '>' . $text . '</label>';
        
        $html[] = $label;
        $html[] = '</span>';
        $html[] = '<span class="after"></span>';
        $html[] = '</span>';

        return implode('', $html);
    }

    /**
     * Method to get the field title.
     *
     * @return  string  The field title.
     *
     * @since   11.1
     */
    protected function getTitle()
    {
        return $this->getLabel();
    }
}
